clear
*use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/fullvars_stack.dta"
*use "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Control Banks\Control_Data\Stack\fullvars_stack.dta", clear

use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Control Banks\Control_Data\Stack\fullvars_stack.dta", clear


drop output_indicator 
**5/24/2016 is our most recent day for PTB 
gen day = day(date)
gen month = month(date)

br name ptb if year == 2016 & month == 5 & day == 24

gen big6 = 0 
replace big6 = 1 if name == "baml" | name == "ms" | name == "jpm" | name == "gs" | name == "wf" | name == "citi"

br name ptb if year == 2016 & month == 5 & day == 24 & big6 == 1 

br name ptb if year == 2016 & month == 5 & day == 24 & big6 == 0 

*** want to do for pre-crisis, crisis, post-crisis 
generate crisis = . 
replace crisis = 0 if year >= 2002 & year <= 2007 
replace crisis = 1 if year >= 2010 & year < 2016


by crisis name, sort: egen ptb_annual_crisis = mean(ptb)
***by year name, sort: egen mve_annual = mean(mve)

by crisis name, sort: gen output_indicator = _n 
br name ptb_annual_crisis crisis big6 if big6 == 1 & output_indicator == 1 
br name ptb_annual_crisis crisis big6 if big6 == 0 & output_indicator == 1 

**** now we want mean and median for the whole crisis period 
keep if big6 == 1 
capture drop output_indicator 
by crisis, sort: gen output_indicator = _n 
by crisis, sort: egen mean_ptb = mean(ptb)
by crisis, sort: egen median_ptb = median(ptb)

br mean_ptb median_ptb crisis if output_indicator == 1 

*** now for 2015 
capture drop output_indicator 
by year name, sort: gen output_indicator = _n 
by year name, sort: egen ptb_annual_year = mean(ptb)
br name ptb_annual_year crisis big6 if big6 == 1 & output_indicator == 1 & year == 2015

**** now we want mean and median annually 
capture drop output_indicator 
by year, sort: gen output_indicator = _n 
by year, sort: egen ptb_mean_overall_year = mean(ptb)
by year, sort: egen ptb_median_overall_year = median(ptb)

br name ptb_mean_overall_year ptb_median_overall_year crisis big6 if big6 == 1 & output_indicator == 1 & year == 2015


*** we want all of this by quintiles for non-big6 

use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Control Banks\Control_Data\Stack\fullvars_stack.dta", clear


capture drop output_indicator 
**5/24/2016 is our most recent day for PTB 
gen day = day(date)
gen month = month(date)

br name ptb if year == 2016 & month == 5 & day == 24

gen big6 = 0 
replace big6 = 1 if name == "baml" | name == "ms" | name == "jpm" | name == "gs" | name == "wf" | name == "citi"

br name ptb if year == 2016 & month == 5 & day == 24 & big6 == 1 

br name ptb if year == 2016 & month == 5 & day == 24 & big6 == 0 

*** want to do for pre-crisis, crisis, post-crisis 
generate crisis = . 
replace crisis = 0 if year >= 2002 & year <= 2007 
replace crisis = 1 if year >= 2010 & year < 2016

*** only want this for the non-big 6, so drop big6 here
drop if big6 == 1 
by crisis name, sort: egen markcap_crisis = mean(markcap)
egen quant_markcap = xtile(markcap_crisis), n(5) by(crisis) 
by crisis quant_markcap, sort: egen ptb_crisis_quant = mean(ptb)

capture drop output_indicator 
drop if crisis == . 
drop if quant_markcap == . 
by crisis quant_markcap, sort: gen output_indicator = _n 
br crisis quant_markcap markcap_crisis ptb_crisis_quant if output_indicator == 1

**** now we want overall mean and median 
capture drop output_indicator
by crisis, sort: gen output_indicator = _n 
by crisis, sort: egen mean_ptb = mean(ptb)
by crisis, sort: egen median_ptb = median(ptb)

br crisis mean_ptb median_ptb if output_indicator == 1 

*** now we want 2015 
by year name, sort: egen markcap_ann = mean(markcap)
egen quant_markcap_ann = xtile(markcap_ann), n(5) by(year) 
by year quant_markcap_ann, sort: egen ptb_ann_quant = mean(ptb)
capture drop output_indicator
by year quant_markcap, sort: gen output_indicator = _n 
br year quant_markcap_ann ptb_ann_quant if output_indicator == 1 & year == 2015 

*** now we want overall mean and median for 2015 
capture drop output_indicator
by year, sort: gen output_indicator = _n 
by year, sort: egen mean_ptb_y = mean(ptb)
by year, sort: egen median_ptb_y = median(ptb)

br crisis mean_ptb_y median_ptb_y if output_indicator == 1 & year == 2015

gen permno = . 
replace permno = 14558 if name == "ally"
replace permno = 59176 if name == "am"
replace permno = 15318 if name == "abb" 
replace permno = 71563 if name == "bbnt" 
replace permno = 76892 if name == "bok"
replace permno = 49656 if name == "bnyc" 
replace permno = 59408 if name == "baml"
replace permno = 84003 if name == "bank"
replace permno = 89463 if name == "cit" & year < 2010 
replace permno = 93150 if name == "cit" & year >= 2010 
replace permno = 81055 if name == "cap"
replace permno = 47896 if name == "jpm"
replace permno  = 70519 if name == "citi"
replace permno = 14889 if name == "citizens"
replace permno = 25081 if name == "comerica"
replace permno = 27888 if name == "cullen"
replace permno = 25129 if name == "bancshares"
replace permno = 92121 if name == "discover"
replace permno = 83862 if name == "e"
replace permno = 86719 if name == "eastwest"
replace permno =13384 if name == "everbank"
replace permno = 34746 if name == "fifththird"
replace permno = 10777 if name == "firstcitizen"
replace permno = 36397 if name == "firsthorizon"
replace permno = 35167 if name == "firstmerit"
replace permno = 85994 if name == "firstniagra"
replace permno = 88343 if name == "pacwest"
replace permno = 35554 if name == "m"
replace permno = 86868 if name == "gs"
replace permno = 76684 if name == "hancock"
replace permno = 42906 if name == "huntington"
replace permno = 81564 if name == "iberia"
replace permno = 90952 if name == "investors"
replace permno = 47896 if name == "jpm"
replace permno = 64995 if name == "keycorp"
replace permno = 69032 if name == "ms"
replace permno = 79859 if name == "newyork"
replace permno = 58246 if name == "northern"
replace permno = 60442 if name == "pnc"
replace permno = 38703 if name == "wf"
replace permno = 12073 if name == "peoples"
replace permno = 86432 if name == "prosperity"
replace permno = 69649 if name == "raymond"
replace permno = 35044 if name == "regions"
replace permno = 11786 if name == "svb"
replace permno = 75186 if name == "schwab"
replace permno = 86004 if name == "umpqua"
replace permno = 72726 if name == "statestreet"
replace permno = 68144 if name == "suntrust"
replace permno = 14776 if name == "synchrony"
replace permno = 20053 if name == "synovus"
replace permno = 10375 if name == "tcf"
replace permno = 66157 if name == "banccorp"
replace permno = 84129 if name == "zions"
replace permno = 84636 if name == "wintrust"
replace permno = 10932 if name == "webster"
replace permno = 80072 if name == "valley"

drop output_indicator 
by permno, sort: gen output_indicator = _n 
br name permno if output_indicator == 1
